@extends('layouts.app')

@section('title', 'My Appointments')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
        <h1 class="text-3xl font-bold text-gray-800">My Appointments</h1>
        <a href="{{ route('patient.dashboard') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
            <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Doctor</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Branch</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach($appointments as $appointment)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $appointment->appointment_date->format('M d, Y H:i') }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $appointment->consultation_type }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $appointment->doctor ? $appointment->doctor->full_name : 'N/A' }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $appointment->branch->name }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 py-1 text-xs rounded-full bg-{{ $appointment->status === 'completed' ? 'green' : ($appointment->status === 'pending' ? 'yellow' : 'blue') }}-100 text-{{ $appointment->status === 'completed' ? 'green' : ($appointment->status === 'pending' ? 'yellow' : 'blue') }}-800">
                            {{ ucfirst($appointment->status) }}
                        </span>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection

